// LSG series Linux API library demo and test program
// Original from HE, mods by RSD 4-15-13
// !untested!

#include <linux/hid.h>	/* AK: Changed include for modern linux */
#include <stdbool.h>	/* AK: Added include for 'bool' type */
#include <stdio.h>
#include <unistd.h>   	/* AK: Added include for error-free getlogin(). */
#include "LSGhid.h"

#define FALSE 0
#define TRUE !FALSE

int main (int argc, char *argv[]) {
  int nDevices, nActive;
  int i, result, status;
  int Fmin, Fmax, itemp;
  float ftemp;
  char cModelName[32];
  char c;
  char *username;
  DEVID activeDevices[MAXDEVICES];

  /* AK: Added <unistd.h> to includes to avoid seg fault on getlogin(). */
  username = getlogin();
  if (0 != strcmp(username, "root")) {
    printf("Hi %s,\r\n", username);
    printf("Accessing USB ports on a Linux machine require root level\r\n");
    printf("access. You are not logged in as root. You may be able to\r\n");
    printf("proceed if you have used 'chmod' to change the access mode\r\n");
    printf("of the appropriate devices in /dev/bus/usb. That requires\r\n");
    printf("root access also. We'll continue, but if you don't see your\r\n");
    printf("LSG devices or no data can be read from or written to them,\r\n");
    printf("that's probably the problem. su to root and try again.\r\n\r\n");
    printf("Try running with 'sudo', or become root by running 'su' before.\r\n\r\n");
  }
  fnLSG_Init();
  fnLSG_SetTestMode(FALSE);
  nDevices = fnLSG_GetNumDevices();
  printf("LSG test/demonstration program using library version %s\r\n\r\n", fnLSG_LibVersion());
  if (0 == nDevices) {
    printf("No Vaunix LSG devices located. Would you like to run in test mode? "); fflush(0);
    c = getchar();
    if ('Y' == (c & 0xdf)) {
      printf("\r\nSwitching to test mode.\r\n");
      fnLSG_Init();
      fnLSG_SetTestMode(TRUE);
      nDevices = fnLSG_GetNumDevices();
    }
  }
  printf("Found %d devices\r\n", nDevices);

  for (i=1; i<=nDevices; i++) {
    result = fnLSG_GetModelName(i, cModelName);
    printf("  Model %d is %s (%d chars)\r\n", i, cModelName, result);
  }
  printf("\r\n");
  
  nActive = fnLSG_GetDevInfo(activeDevices);
  printf("We have %d active devices\r\n", nActive);

  for (i=0; i<nActive; i++) {
    if (i > 0) printf("\r\n");
    printf("  Device %d is active\r\n", activeDevices[i]);
    status = fnLSG_InitDevice(activeDevices[i]);
    printf("  Opened device %d. Return status=0x%08x (%s)\r\n", activeDevices[i], status, fnLSG_perror(status));

    printf("Before we do any tests, let's let the DLL get to know the device..."); fflush(0);
    sleep(3);
    printf("That should do it.\r\n");
	
	// get some basic info about the device

    status = fnLSG_GetModelName(activeDevices[i], cModelName);
    printf("  Device %d (%s) has ", activeDevices[i], cModelName);
    status = fnLSG_GetSerialNumber(activeDevices[i]);
    printf("serial number=%d\r\n", status);
	
	Fmin = fnLSG_GetMinFreq(activeDevices[i]);
	Fmax = fnLSG_GetMaxFreq(activeDevices[i]);
	printf(" Minimum Frequency = %d\r\n", Fmin);
	printf(" Maximum Frequency = %d\r\n", Fmax);

	// send some commands
	
	itemp = Fmin + (Fmax - Fmin)/2;
	ftemp = (float) itemp / 10000;	// convert to frequency in GHz
	
    status = fnLSG_SetFrequency(activeDevices[i],  itemp);
    printf("  Set frequency to %f GHz. Status=0x%08x (%s)\r\n", ftemp, status, fnLSG_perror(status));
	
    result = fnLSG_GetFrequency(activeDevices[i]);
    printf("  Read frequency back and got %d\r\n", result);

	itemp = Fmin + (Fmax - Fmin)/3;
	ftemp = (float) itemp / 10000;	// convert to frequency in GHz
	
    status = fnLSG_SetStartFrequency(activeDevices[i], itemp);
	
    printf("  Set sweep start frequency to %f GHz. Status=0x%08x (%s)\r\n", ftemp, status, fnLSG_perror(status));    
    result = fnLSG_GetStartFrequency(activeDevices[i]);
    printf("  Read start frequency back and got %d\r\n", result);

	itemp = Fmin + 2*(Fmax - Fmin)/3;
	ftemp = (float) itemp / 10000;	// convert to frequency in GHz
	
    status = fnLSG_SetEndFrequency(activeDevices[i], itemp);
    printf("  Set sweep end frequency to %f GHz. Status=0x%08x (%s)\r\n", ftemp, status, fnLSG_perror(status));    
    result = fnLSG_GetEndFrequency(activeDevices[i]);
    printf("  Read end frequency back and got %d\r\n", result);
	
	itemp = Fmin + (Fmax - Fmin)/100;
	ftemp = (float) itemp / 10000;	// convert to frequency in GHz
	
    status = fnLSG_SetFrequencyStep(activeDevices[i], itemp);
    printf("  Set sweep frequency step to %f GHz. Status=0x%08x (%s)\r\n", ftemp, status, fnLSG_perror(status));    
    result = fnLSG_GetFrequencyStep(activeDevices[i]);
    printf("  Read frequency step back and got %d\r\n", result);
	
    status = fnLSG_SetDwellTime(activeDevices[i], 200);
    printf("  Set sweep dwell time to .2 sec. Status=0x%08x (%s)\r\n", status, fnLSG_perror(status));    
    result = fnLSG_GetSweepTime(activeDevices[i]);
    printf("  Read sweep time back and got %d\r\n", result);

    status = fnLSG_SetPowerLevel(activeDevices[i], 0);
    printf("  Set power level to 0 db. Status=0x%08x (%s)\r\n", status, fnLSG_perror(status));    
    result = fnLSG_GetPowerLevel(activeDevices[i]);
    printf("  Read attenuation level back and got %d\r\n", result);		// Note -- the API returns attenuation, but you set power!

    status = fnLSG_SetRFOn(activeDevices[i], TRUE);
    printf("  Set RF on. Status=0x%08x (%s)\r\n", status, fnLSG_perror(status));    
   
    status = fnLSG_SetUseInternalRef(activeDevices[i], TRUE);
    printf("  Set UseInternalRef TRUE. Status=0x%08x (%s)\r\n", status, fnLSG_perror(status));    

    status = fnLSG_SetSweepDirection(activeDevices[i], TRUE);
    printf("  Set sweep direction TRUE. Status=0x%08x (%s)\r\n", status, fnLSG_perror(status));    

    status = fnLSG_SetSweepMode(activeDevices[i], TRUE);
    printf("  Set sweep mode TRUE. Status=0x%08x (%s)\r\n", status, fnLSG_perror(status));    

    status = fnLSG_StartSweep(activeDevices[i], TRUE);
    printf("  Started sweep. Status=0x%08x (%s)\r\n", status, fnLSG_perror(status));    

    status = fnLSG_CloseDevice(activeDevices[i]);
    printf("  Closed device %d. Return status=0x%08x (%s)\r\n", activeDevices[i], status, fnLSG_perror(status));
  }
  printf("End of test\r\n");
  return 0;
}
